<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Province Wise Sale - Pakistan Map</title>
  <script src="https://cdn.jsdelivr.net/npm/echarts@5.4.2/dist/echarts.min.js"></script>
  <style>
    #province_chart {
      width: 800px;
      height: 600px;
      margin: 20px auto;
      border: 1px solid #ccc;
    }
  </style>
</head>
<body>

  <div id="province_chart"></div>

  <script>
    // GeoJSON file loading and ECharts initialization
    var echartsMapInit = function () {
      var mapEl = document.querySelector('#province_chart');

      // Demo data for provinces
      var data = [
        { name: 'Punjab', value: 25000000 },
        { name: 'Sindh', value: 18000000 },
        { name: 'Khyber Pakhtunkhwa', value: 12000000 },
        { name: 'Balochistan', value: 8000000 }
      ];

      // Check if map container exists
      if (mapEl) {
        fetch('pakistan.json') // Replace with the actual path to your GeoJSON file
          .then(response => response.json())
          .then(geoJson => {
            echarts.registerMap('pakistan', geoJson); // Register Pakistan map

            var chart = echarts.init(mapEl);

            var option = {
              tooltip: {
                trigger: 'item',
                formatter: function (params) {
                  return `<strong>${params.data.name}:</strong> ${params.data.value}`;
                }
              },
              visualMap: {
                left: 'right',
                min: 0,
                max: 30000000, // Adjust max based on your data range
                inRange: {
                  color: ['#e0f3f8', '#2166ac'] // Gradient from light to dark blue
                },
                text: ['High', 'Low'],
                calculable: true
              },
              series: [{
                type: 'map',
                map: 'pakistan', // Matches the registered map
                zoom: 1.3,
                itemStyle: {
                  borderColor: '#ccc',
                  borderWidth: 1
                },
                emphasis: {
                  label: {
                    show: true,
                    color: '#fff'
                  },
                  itemStyle: {
                    areaColor: '#ffc107' // Highlight color on hover
                  }
                },
                data: data // Province-wise data bound here
              }]
            };

            chart.setOption(option); // Apply the options to the chart
          })
          .catch(error => console.error('Error loading GeoJSON:', error));
      }
    };

    // Initialize the map
    echartsMapInit();
  </script>

</body>
</html>
