<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Table Filter Example</title>

    <!-- TableFilter CSS -->
    <link rel="stylesheet" href="./tablefilter/style/tablefilter.css">

    <style>
        table {
            width: 100%;
            border-collapse: collapse;
        }
        th, td {
            padding: 8px;
            border: 1px solid #ddd;
            text-align: left;
        }
    </style>
</head>
<body>

<!-- Table -->
<table id="demo">
    <thead>
        <tr>
            <th>Column 1</th>
            <th>Column 2</th>
            <th>Column 3</th>
            <th>Column 4</th>
            <th>Column 5</th>
            <th>Column 6</th>
            <th>Column 7</th>
            <th>Column 8</th>
            <th>Column 9</th>
        </tr>
    </thead>
    <tbody>
        <tr>
            <td>Data 1</td>
            <td>Data 2</td>
            <td>100</td>
            <td>200</td>
            <td>500</td>
            <td>1500</td>
            <td>3000</td>
            <td>6000</td>
            <td>8000</td>
        </tr>
        <tr>
            <td>Data 1</td>
            <td>Data 2</td>
            <td>250</td>
            <td>400</td>
            <td>1000</td>
            <td>2500</td>
            <td>4500</td>
            <td>7000</td>
            <td>10000</td>
        </tr>
        <tr>
            <td>Data 3</td>
            <td>Data 4</td>
            <td>10000</td>
            <td>15000</td>
            <td>30000</td>
            <td>100000</td>
            <td>200000</td>
            <td>300000</td>
            <td>400000</td>
        </tr>
    </tbody>
        <tfoot>
        <tr>
            <td colspan="8">Subtotal</td>
            <td id="subtotal9">0</td>
        </tr>
    </tfoot>
</table>
<!-- TableFilter JS -->
<script src="./tablefilter/tablefilter.js"></script>
<script>
    // Function to format numbers with commas
    function formatNumber(number) {
        return new Intl.NumberFormat().format(number);
    }

    // Function to calculate the subtotal for column 9, considering only visible rows
    function calculateSubtotal() {
        const rows = document.querySelectorAll('#demo tbody tr');
        let subtotal9 = 0;

        rows.forEach(row => {
            if (row.style.display !== 'none') { // Only count visible rows
                const value9 = parseFloat(row.cells[8].innerText.replace(/,/g, '')) || 0; // Remove commas for calculation
                subtotal9 += value9;
            }
        });

        // Update the subtotal row (tfoot)
        const subtotalCell = document.getElementById('subtotal9');
        subtotalCell.innerText = formatNumber(subtotal9);
    }

    // Function to format numbers in the table columns
    function formatTableNumbers() {
        const rows = document.querySelectorAll('#demo tbody tr');
        rows.forEach(row => {
            for (let i = 6; i < 9; i++) {
                const cell = row.cells[i];
                const rawValue = parseFloat(cell.innerText);
                if (!isNaN(rawValue)) {
                    cell.innerText = formatNumber(rawValue);  // Format the number with commas
                }
            }
        });
    }

    // Table filter configuration
    var filtersConfig = {
        col_1: 'select',
        col_2: 'select',
        col_3: 'select',
        alternate_rows: true,
        rows_counter: true,
        btn_reset: true,
        loader: true,
        status_bar: true,
        no_results_message: true,
        col_types: [
            'string', 'string', 'number',
            'number', 'number', 'number',
            'number', 'number', 'number'
        ],
        custom_options: {
            cols: [3],
            texts: [
                [
                    'na', '0 - 50', '50 - 500',
                    '500 - 15 000', '15 000 - 25 000', '25 000 - 100 000',
                    '100 000 - 1 500 000', 'not na'
                ]
            ],
            values: [
                [
                    'na', '>0 && <=50', '>50 && <=500',
                    '>500 && <=15000', '>15000 && <=25000',
                    '>25000 && <=100000', '>100000 && <=1500000', '!na'
                ]
            ],
            sorts: [false] // Disable sorting on custom filter columns
        },
        col_widths: [
            '150px', '100px', '100px',
            '70px', '70px', '70px',
            '70px', '60px', '60px'
        ],
        extensions: [
            {
                name: 'sort', // Enable sorting for all columns
                types: ['string', 'string', 'number', 'number', 'number', 'number', 'number', 'number', 'number'],
                enable: true // Ensure sorting is enabled
            }
        ]
    };

    // Initialize TableFilter and apply number formatting after initialization
    var tf = new TableFilter('demo', filtersConfig);
    tf.init();

    // Recalculate the subtotal after filtering or sorting
    tf.emitter.on(['filter', 'sort'], calculateSubtotal);

    // Format the numbers in the table after initialization
    formatTableNumbers();

    // Calculate subtotal on page load
    calculateSubtotal();
</script>


</body>
</html>